﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class sp_book : sp.userbase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
           
            Bind();
        }
    }

    private void Bind()
    {
        sp.DAL.sp_book sb = new sp.DAL.sp_book();
        DataView dv = sb.GetList("").Tables[0].DefaultView;
        PagedDataSource pds = new PagedDataSource();

        AspNetPager1.RecordCount = dv.Count;
        pds.DataSource = dv;
        pds.AllowPaging = true;
        pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
        pds.PageSize = AspNetPager1.PageSize;

        this.GridView1.DataSource = pds;
        this.GridView1.DataBind();
    }

    protected void AspNetPager1_PageChanged(object src, EventArgs e)
    {
        
        Bind();
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        /******************************增加窗体代码********************************/
        string Sp_CONTENT = this.txtSp_CONTENT.Text;
        string strErr = "";
        
        if (Sp_CONTENT == "")
        {
            strErr += "留言内容不能为空！\\n";
        }
        if (TextBoChk.Text != Request.Cookies["CheckCode"].Value)
        {
            strErr += "您输入的验证码不正确！\\n";
        }
        if (strErr != "")
        {
            sp.MessageBox.Show(this, strErr);
            return;
        }
        string Sp_NAME = this.txtSp_NAME.Text;
        string Sp_Email = this.txtSp_Email.Text;
        string Sp_HomePage = this.txtSp_HomePage.Text;
        string Sp_qq = this.txtSp_qq.Text;
        string Sp_msn = this.txtSp_msn.Text;
        string Sp_UserFrom = Request.Form["GM_AREA"];

        string Sp_REPLY = string.Empty;
        string Sp_REPLY_EMAIL = GM_REPLY_EMAIL.Checked.ToString();
        DateTime Sp_ADDTIME = DateTime.Now;
        DateTime Sp_RETIME = DateTime.Now;
        string Sp_IP = Request.ServerVariables["Remote_Addr"].ToString();

        sp.Model.sp_book model = new sp.Model.sp_book();
        model.Sp_NAME = Sp_NAME;
        model.Sp_Email = Sp_Email;
        model.Sp_HomePage = Sp_HomePage;
        model.Sp_qq = Sp_qq;
        model.Sp_msn = Sp_msn;
        model.Sp_UserFrom = Sp_UserFrom;
        model.Sp_CONTENT = Sp_CONTENT;
        model.Sp_REPLY = Sp_REPLY;
        model.Sp_REPLY_EMAIL = bool.Parse(Sp_REPLY_EMAIL);
        model.Sp_ADDTIME = Sp_ADDTIME;
        model.Sp_RETIME = Sp_RETIME;
        model.Sp_IP = Sp_IP;

        sp.DAL.sp_book sb = new sp.DAL.sp_book();
        sb.Add(model);
        sp.MessageBox.Show(this,"谢谢您的参与！");
        Bind();
    }
   

}
